import copy

import six

from crypta.lib.python.spine.consts import environment


class TaskConfig(object):
    """
    Helper config for creating schedulers for multiple environments
    """
    def __init__(self, task_cls, stable=None, testing=None, testing_from_stable=False):
        """
        :param task_cls: class derived from :class:`~sandbox.projects.crypta.common.CryptaTask`
        :param stable: :class:`RunConfig`
        :param testing: :class:`RunConfig`
        :param testing_from_stable: if True, testing config is copied from stable
        """
        if stable is not None:
            assert isinstance(stable, RunConfig)
            self.stable = CompleteConfig(task_cls, environment.STABLE, stable)
        else:
            self.stable = None

        if testing is not None:
            assert isinstance(testing, RunConfig)
            self.testing = CompleteConfig(task_cls, environment.TESTING, testing)
        elif testing_from_stable:
            self.testing = copy.deepcopy(self.stable)
            self.testing.env = environment.TESTING
        else:
            self.testing = None

    def __iter__(self):
        if self.stable:
            yield self.stable

        if self.testing:
            yield self.testing


# TODO(cherenkov-p-a) Refactor config classes
CHECK_CONFIG_FIELDS = ["crit_time", "juggler_service"]


class RunConfig(object):
    def __init__(
        self,
        schedule_interval=None,
        kill_timeout=None,
        schedule_daily_start_time=None,
        retry_interval=None,
        extra_params=None,
        tags=None,
        notifications=None,
        sequential_run=True,
        crit_time=None,
        juggler_service=None,
    ):
        self.schedule_interval = schedule_interval
        self.kill_timeout = kill_timeout
        self.schedule_daily_start_time = schedule_daily_start_time
        self.retry_interval = retry_interval
        self.extra_params = extra_params
        self.tags = tags
        self.notifications = notifications
        self.sequential_run = sequential_run
        self.crit_time = crit_time
        self.juggler_service = juggler_service


class CompleteConfig(object):
    def __init__(self, task_cls, env, run_config):
        self.task_cls = task_cls
        self.env = env
        self.__dict__.update(run_config.__dict__)

    def get_scheduler_config(self):
        return {k: v for k, v in six.iteritems(self.__dict__) if k not in CHECK_CONFIG_FIELDS}

    def get_check_config(self):
        return {k: v for k, v in six.iteritems(self.__dict__) if k in CHECK_CONFIG_FIELDS}
