from crypta.lib.python.spine.config_registry import ConfigRegistry
from crypta.lib.python.spine.consts import environment
from crypta.lib.python.spine.yasm.yasm_dashboard import YasmDashboard

from crypta.lib.python.yasm import (
    owners,
    templates,
)


class YasmDashboardGenerator(ConfigRegistry):
    def __init__(self, owners, meta_project, project):
        super(YasmDashboardGenerator, self).__init__()
        self.owners = owners
        self.meta_project = meta_project
        self.project = project

    def add_devops(self, service, prj_tag, envs=tuple(environment.ALL)):
        for env in envs:
            self.store(YasmDashboard.REGISTRY_TAG, YasmDashboard(
                self.owners,
                self.meta_project,
                self.project,
                service,
                templates.DevopsTemplate.create_node(itype="yp", ctype=env, prj=prj_tag)
            ))


class CryptaYtYasmDashboardGenerator(YasmDashboardGenerator):
    def __init__(self, project):
        super(CryptaYtYasmDashboardGenerator, self).__init__(owners.get_crypta_yt_owners(), "Crypta", project)
