from crypta.lib.python.spine.consts import environment
from crypta.lib.python.spine.config_registry import ConfigRegistry


DEPRECATED_ROOTS = {
    environment.PRODUCTION: "//home/crypta/production",
    environment.TESTING: "//home/crypta/testing/sandbox",
}

DEFAULT_ROOTS = {
    environment.PRODUCTION: "//home/crypta/production",
    environment.TESTING: "//home/crypta/testing",
}

DEFAULT_SOLOMON_PROJECT = "crypta_stats"


class YtConfigRegistry(ConfigRegistry):
    def __init__(self, juggler_check_generator, root_paths, solomon_project):
        """
        Config registry with parameter required by yt_* configs
        :param juggler_check_generator: :class:`~crypta.lib.python.spine.juggler.juggler_check_generator.JugglerCheckGenerator`
        Adds self as subregistry of juggler_check_generator
        :param root_paths: dict {env: root_path}
        :param solomon_project: Solomon project where metrics and alerts will be stored
        """
        super(YtConfigRegistry, self).__init__()
        juggler_check_generator.add_subregistry(self)
        self.root_paths = root_paths
        self.juggler_check_generator = juggler_check_generator
        self.solomon_project = solomon_project


class CryptaYtConfigRegistry(YtConfigRegistry):
    def __init__(self, juggler_check_generator):
        super(CryptaYtConfigRegistry, self).__init__(juggler_check_generator, DEFAULT_ROOTS, DEFAULT_SOLOMON_PROJECT)


class DeprecatedCryptaYtConfigRegistry(YtConfigRegistry):
    def __init__(self, juggler_check_generator):
        super(DeprecatedCryptaYtConfigRegistry, self).__init__(juggler_check_generator, DEPRECATED_ROOTS, DEFAULT_SOLOMON_PROJECT)
