import datetime

from crypta.lib.python.solomon.proto import alert_pb2
from crypta.lib.python.spine.consts import environment
from crypta.lib.python.spine.yt.yt_metric import YtMetric

AGE = "age"
LATENCY = "latency"
TABLE_LATENCY = "table_latency"


class YtLatencyMetric(YtMetric):
    """
    Adds 'age' metrics for YT nodes
    Also adds "[table_]latency metrics if path is directory
    """
    REGISTRY_TAG = "yt_latency_metric"

    def add_age_alert(self, threshold, env=environment.PRODUCTION):
        """
        YT node age alert
        :param threshold: :class:`~datetime.timedelta`
        :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
        """
        return self._add_yt_latencies_alert(AGE, threshold, env)

    def add_latency_alert(self, threshold, env=environment.PRODUCTION):
        """
        Alert for age of the oldest node in YT directory
        :param threshold: :class:`~datetime.timedelta`
        :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
        """
        return self._add_yt_latencies_alert(LATENCY, threshold, env)

    def add_table_latency_alert(self, threshold, env=environment.PRODUCTION):
        """
        Alert for age of the oldest table in YT directory
        :param threshold: :class:`~datetime.timedelta`
        :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
        """
        return self._add_yt_latencies_alert(TABLE_LATENCY, threshold, env)

    def _add_yt_latencies_alert(self, metric, threshold, env):
        return self._add_alert(
            "yt_latencies",
            metric,
            lambda x: datetime.timedelta(seconds=x),
            threshold.total_seconds(),
            alert_pb2.GT,
            env,
        )
