import datetime

from crypta.lib.python.solomon.proto import alert_pb2
from crypta.lib.python.spine.consts import environment
from crypta.lib.python.spine.yt.yt_metric import YtMetric

OUTPUT_TABLE_LATENCY = "output_table_latency"


class YtOutputTableLatencyMetric(YtMetric):
    """
    Adds latency metrics for output tables in YT directories
    """
    REGISTRY_TAG = "yt_output_table_latency_metric"

    def add_output_table_latency_alert(self, threshold, env=environment.PRODUCTION):
        """
        Alert for latency of the next table expected to appear in a YT directory
        :param threshold: :class:`~datetime.timedelta`
        :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
        """
        return self._add_yt_output_table_latencies_alert(OUTPUT_TABLE_LATENCY, threshold, env)

    def _add_yt_output_table_latencies_alert(self, metric, threshold, env):
        return self._add_alert(
            "yt_output_table_latencies",
            metric,
            lambda x: datetime.timedelta(seconds=x),
            threshold.total_seconds(),
            alert_pb2.GT,
            env,
        )
