import datetime

from crypta.lib.python.solomon.proto import alert_pb2
from crypta.lib.python.spine.consts import environment
from crypta.lib.python.spine.yt.yt_metric import YtMetric

LAG = "lag"


class YtProcessedTablesMetric(YtMetric):
    """
    Tracks state of special processed table logs at YT, maintained by following libraries
    - https://a.yandex-team.ru/arc/trunk/arcadia/crypta/lib/native/yt/processed_tables_tracker
    - https://a.yandex-team.ru/arc/trunk/arcadia/crypta/lib/python/yt/processed_tables_tracker
    Adds "lag" metric
    """

    REGISTRY_TAG = "yt_processed_tables_metric"

    def add_lag_alert(self, threshold, env=environment.PRODUCTION):
        """
        Alert for "lag" metric
        :param threshold: :class:`~datetime.timedelta`
        :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
        """
        return self._add_alert(
            service="yt_processed_tables_metrics",
            metric=LAG,
            humanize_func=lambda x: datetime.timedelta(seconds=x),
            threshold=threshold.total_seconds(),
            predicate=alert_pb2.GT,
            env=env,
        )
