import humanize

from crypta.lib.python.spine.consts import environment
from crypta.lib.python.spine.yt.yt_metric import YtMetric


class YtSizeMetric(YtMetric):
    """
    Tracks disk space for YT nodes
    If node is a table, also tracks "row_count" for static tables and "unmerged_row_count" for dynamic tables
    """
    REGISTRY_TAG = "yt_size_metric"

    def add_disk_space_alert(self, threshold, predicate, env=environment.PRODUCTION, period=None):
        """
        :param threshold: :class:`~crypta.lib.python.data_size.DataSize`
        :param predicate: :class:`~crypta.lib.python.solomon.proto.alert_pb2.ECompare`
        :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
        """
        return self._add_yt_sizes_alert(
            "disk_space",
            humanize.naturalsize,
            threshold.total_bytes(),
            predicate,
            env,
            period=period,
        )

    def add_unmerged_row_counts_alert(self, threshold, predicate, env=environment.PRODUCTION):
        """
        :param threshold: int`
        :param predicate: :class:`~crypta.lib.python.solomon.proto.alert_pb2.ECompare`
        :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
        """
        return self._add_yt_sizes_alert(
            "unmerged_row_count",
            humanize.intword,
            threshold,
            predicate,
            env,
        )

    def add_row_count_alert(self, threshold, predicate, env=environment.PRODUCTION):
        """
        :param threshold: int`
        :param predicate: :class:`~crypta.lib.python.solomon.proto.alert_pb2.ECompare`
        :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
        """
        return self._add_yt_sizes_alert(
            "row_count",
            humanize.intword,
            threshold,
            predicate,
            env,
        )

    def add_chunk_count_alert(self, threshold, predicate, env=environment.PRODUCTION):
        """
        :param threshold: int`
        :param predicate: :class:`~crypta.lib.python.solomon.proto.alert_pb2.ECompare`
        :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
        """
        return self._add_yt_sizes_alert(
            "chunk_count",
            humanize.intword,
            threshold,
            predicate,
            env,
        )

    def add_node_count_alert(self, threshold, predicate, env=environment.PRODUCTION):
        """
        :param threshold: int`
        :param predicate: :class:`~crypta.lib.python.solomon.proto.alert_pb2.ECompare`
        :return: :class:`~crypta.lib.python.spine.juggler.juggler_aggregate_check.JugglerAggregateCheck`
        """
        return self._add_yt_sizes_alert(
            "node_count",
            humanize.intword,
            threshold,
            predicate,
            env,
        )

    def _add_yt_sizes_alert(self, metric, humanize_func, threshold, predicate, env, period=None):
        return self._add_alert("yt_sizes", metric, humanize_func, threshold, predicate, env, period=period)
