# coding: utf-8

import argparse
import datetime
import logging
import time

from crypta.lib.python.argparse_utils import boolean_as_string

from crypta.lib.python.statface.example import common
from crypta.lib.python.statface.statface_sender import (
    create_or_update_report,
    upload_to_statface,
)
from statface_client.constants import (
    DAILY_SCALE,
)


DATA = [{
    "foo": time.time() / 86400,
    "fielddate": datetime.datetime.now().date().isoformat()
}]

MEASURES = [
    "foo"
]

ADDITIONAL_DIMENSIONS = []

TITLES = {
    "foo": u"Foo (py)",
    "fielddate": u"Дата (py)"
}

logger = logging.getLogger(__name__)


def init_args():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument("--log-config", required=True, help="Log config")
    parser.add_argument("--report-path", required=True, help="Report path, e.g. 'Adhoc/r-andrey/test-3', see https://stat-beta.yandex-team.ru/Adhoc/r-andrey/test-3")
    parser.add_argument("--report-title", required=True, help="Report title")
    parser.add_argument("--statface-is-production", default="false", help="Send to Statface production installation (true | false)", type=boolean_as_string)

    args = parser.parse_args()

    return args


def main():
    args = init_args()
    common.configure_logger(args.log_config)

    logger.info(u"DATA: %s", DATA)
    logger.info(u"TITLES: %s", TITLES)

    report_path = args.report_path
    create_or_update_report(report_path, args.report_title, MEASURES, ADDITIONAL_DIMENSIONS, TITLES, args.statface_is_production)
    upload_to_statface(report_path, DATA, DAILY_SCALE, args.statface_is_production)


if __name__ == "__main__":
    main()
