import jinja2
import six

from library.python import resource


def render_template(template_text, vars=None, strict=False):
    vars = vars or {}
    undefined = jinja2.StrictUndefined if strict else jinja2.Undefined
    return jinja2.Template(template_text, trim_blocks=True, lstrip_blocks=True, undefined=undefined).render(**vars)


def render_file(template_file, output_file, vars, strict=False):
    with open(template_file) as f:
        template = f.read()

    with open(output_file, "w") as out:
        out.write(render_template(template, vars, strict))


def render_resource(resource_name, vars=None, strict=False):
    template = six.ensure_str(resource.find(resource_name), "utf-8")
    return render_template(template, vars, strict)


def split_vars(vars, delimiter="="):
    return {k: v for k, v in [var.split(delimiter, 1) for var in vars]}
