#pragma once

#include <kernel/inflectorlib/fio/core/fio_text.h>
#include <kernel/inflectorlib/fio/rus_fio/rus_fio_language.h>

#include <util/generic/string.h>
#include <util/stream/input.h>
#include <util/stream/output.h>


namespace NFio {

    TString GuessGender(const TString& fio) {
        const auto* lang = TRusFIOLanguage::GetLang();
        TUtf16String fioUtf16 = TUtf16String::FromUtf8(fio);
        EGrammar gender = NFioInflector::GuessGender(lang, fioUtf16);
        return TGrammarIndex::GetLatinName(gender);
    }

}
