from util.generic.string cimport TString, TStringBuf

import six


cdef extern from "library/cpp/langmask/langmask.h" namespace "NLanguageMasks":
    cdef cppclass TLangMask:
        TLangMask()

    cdef const TLangMask& BasicLanguages()


cdef extern from "ysite/yandex/reqanalysis/normalize.h" namespace "NQueryNorm":
    cdef cppclass TDoppNormalizer:
        TDoppNormalizer()
        TString NormalizeSafe(const TStringBuf& req, const TLangMask& lm)


cdef Normalize(bytes data):
    return TDoppNormalizer().NormalizeSafe(TStringBuf(data, len(data)), BasicLanguages())

def normalize(data):
    return six.ensure_str(Normalize(six.ensure_binary(data)))
