import datetime
import os
import time

import pytz
import six


CRYPTA_FROZEN_TIME_ENV = "CRYPTA_FROZEN_TIME"
MOSCOW_TZ = pytz.timezone("Europe/Moscow")


def get_current_time():
    return int(os.environ.get(CRYPTA_FROZEN_TIME_ENV, time.time()))


def set_current_time(ts):
    os.environ[CRYPTA_FROZEN_TIME_ENV] = str(ts)


def get_current_moscow_datetime():
    return datetime.datetime.fromtimestamp(get_current_time(), MOSCOW_TZ)


def fromisoformat_moscow(s):
    if six.PY3:
        return MOSCOW_TZ.localize(datetime.datetime.fromisoformat(s))
    else:
        raise NotImplementedError("fromisoformat_moscow is not implemented for PY2. Please use PY3")
