import marisa_trie


ONE_FLOAT = 'f'


def create_trie(kv_pairs=None, fmt=ONE_FLOAT):
    return marisa_trie.RecordTrie(fmt, kv_pairs)


def load_trie(filename, fmt=ONE_FLOAT):
    trie = create_trie(fmt=fmt)
    trie.load(filename)
    return trie


class AsciiTrie(object):
    @staticmethod
    def filter_ascii_characters(text):
        return (filter(lambda ch: 0 < ord(ch) < 256, str(text))
                .decode('utf-8', "ignore"))

    def __init__(self, trie):
        self._trie = trie

    def get(self, text, default_value=0.):
        return self._trie.get(self.filter_ascii_characters(text),
                              [(default_value,)])[0][0]

    def iteritems(self):
        return self._trie.iteritems()

    def items(self):
        return self._trie.items()

    def keys(self):
        return self._trie.keys()


def load_ascii_trie(*args, **kwargs):
    return AsciiTrie(load_trie(*args, **kwargs))
