import six


def tskv_to_dict(dsv):
    return {k: v for k, v in [x for x in [x.split('=', 1) for x in dsv.split('\t')] if len(x) == 2]}


def dict_to_tskv(dct):
    def serialize_pair(kvp):
        serialized_pair = "{}={}".format(kvp[0], kvp[1])

        if "\t" in serialized_pair:
            raise Exception("Key-value pair '{}' contains tabs".format(serialized_pair))

        return serialized_pair

    return "\t".join([serialize_pair(kvp) for kvp in six.iteritems(dct)])
