import os

TVM_SECRET_ENV_VAR = "TVM_SECRET"
TVM_TICKET_HEADER_KEY = "X-Ya-Service-Ticket"
TVM_USER_TICKET_USER_HEADER_KEY = "X-Ya-User-Ticket"
TVM_TEST_PORT_ENV_VAR = "TVM_TEST_PORT"


def get_tvm_headers(ticket):
    return {TVM_TICKET_HEADER_KEY: ticket} if ticket is not None else {}


def get_tvm_headers_with_user(service_ticket, user_ticket):
    result = {}

    if service_ticket is not None:
        result[TVM_TICKET_HEADER_KEY] = service_ticket

    if user_ticket is not None:
        result[TVM_USER_TICKET_USER_HEADER_KEY] = user_ticket

    return result


def get_tvm_test_port():
    port = os.environ.get(TVM_TEST_PORT_ENV_VAR)
    return int(port) if port is not None else None
