import threading

import flask
from library.python.monlib import encoder


CONTENT_TYPE_SPACK = 'application/x-solomon-spack'
CONTENT_TYPE_JSON = 'application/json'


class StatsServer:
    def __init__(self, host, port, registry):
        self.app = flask.Flask(__name__)

        self.host = host
        self.port = port
        self.registry = registry

        @self.app.route('/metrics')
        def metrics():
            if flask.request.headers.get('accept', None) == CONTENT_TYPE_SPACK:
                return flask.Response(encoder.dumps(self.registry), mimetype=CONTENT_TYPE_SPACK)

            return flask.Response(encoder.dumps(self.registry, format='json'), mimetype=CONTENT_TYPE_JSON)

        @self.app.route('/ping')
        def ping():
            return 'Ok'

    def start(self):
        self.server_thread = threading.Thread(target=self.app.run, args=(self.host, self.port))
        self.server_thread.setDaemon(True)
        self.server_thread.start()
