import logging

from library.python.monlib import metric_registry

logger = logging.getLogger(__name__)


class TaskMetrics:
    ERRORS = "errors"
    PROCESSED = "processed"
    PROCESSING_TIME_SECONDS = "processing_time_seconds"
    BUCKETS = (1, 2, 5, 10, 20, 50, 100, 200, 500, 1000)

    def __init__(self, mp_metric_registry, labels):
        self.processing_time_seconds = mp_metric_registry.histogram_rate(
            make_sensor(self.PROCESSING_TIME_SECONDS, labels),
            metric_registry.HistogramType.Explicit,
            buckets=self.BUCKETS,
        )
        self.errors = mp_metric_registry.rate(make_sensor(self.ERRORS, labels))
        self.processed = mp_metric_registry.rate(make_sensor(self.PROCESSED, labels))


def make_sensor(sensor, labels):
    return dict(labels, sensor=sensor)
