import logging
import time

from frozendict import frozendict
from six.moves import queue

logger = logging.getLogger(__name__)


class Worker(object):
    def __init__(self, worker_config):
        self.worker_config = worker_config

        self.done_queue = worker_config.done_queue
        self.mp_metric_registry = worker_config.mp_metric_registry
        self.task_queue = worker_config.task_queue
        self.running = worker_config.running
        self.metrics = worker_config.metrics

    def run(self):
        while self.running.value:
            success = False
            processing_time_seconds = 0
            labels = {}

            try:
                task = self.task_queue.get(timeout=1)

                start_time = time.time()

                self.execute(task.task, labels)

                processing_time_seconds = time.time() - start_time

                self.done_queue.put_nowait(task)
                success = True
            except queue.Empty:
                continue
            except Exception:
                logger.exception("Failed all attempts to process task: %s", task)
                self.done_queue.put_nowait(task)

            try:
                frozen_labels = frozendict(labels)

                if success:
                    self.metrics[frozen_labels].processing_time_seconds.collect(processing_time_seconds)
                    self.metrics[frozen_labels].processed.inc()
                else:
                    self.metrics[frozen_labels].errors.inc()
            except Exception:
                logger.exception("Failed to collect metrics: %s", labels)

        logger.info("Worker finished")

    def execute(self, task, lables):
        raise NotImplementedError
