import json

from library.python.protobuf.json.proto2json import (
    FldNameMode,
    proto2json,
    Proto2JsonConfig,
)
import yaml

from crypta.lib.python.yaml2proto.yaml2proto import yaml2proto


def proto2yaml(proto, config=None):
    config = config or Proto2JsonConfig(
        field_name_mode=FldNameMode.FieldNameSnakeCase,
        map_as_object=True,
    )

    return yaml.safe_dump(json.loads(proto2json(proto, config)))


def yaml2protos(s, proto_cls, config=None):
    protos = []

    for d in yaml.safe_load(s):
        proto = proto_cls()
        yaml2proto(yaml.safe_dump(d), proto, config=config)
        protos.append(proto)

    return protos


__all__ = [
    proto2yaml,
    yaml2proto,
    yaml2protos,
]
