from cython.operator cimport dereference
from library.python.protobuf.dynamic_prototype.dynamic_prototype cimport (
    get_dynamic_message,
    Message,
    TDynamicMessage,
)
from library.python.protobuf.json.json2proto cimport (
    TJson2ProtoConfig,
    Json2ProtoConfig,
)
import six
from util.generic.string cimport TString
from util.generic.ptr cimport TIntrusivePtr


cdef extern from "crypta/lib/native/yaml/yaml2proto.h" namespace "NCrypta" nogil:
    cdef void Yaml2Proto(const TString&, Message&) except +;
    cdef void Yaml2Proto(const TString&, Message&, const TJson2ProtoConfig&) except +;


def yaml2proto(yaml, proto, config=None):
    cdef TDynamicMessage cpp_proto = get_dynamic_message(proto)
    yaml = six.ensure_binary(yaml)

    if config is None:
        Yaml2Proto(yaml, dereference(cpp_proto.Get()))
    else:
        Yaml2Proto(yaml, dereference(cpp_proto.Get()), (<Json2ProtoConfig>config).base)

    if not proto.ParseFromString(dereference(cpp_proto.Get()).SerializeAsString()):
        raise Exception("Failed to transfer protobuf from C++ to Python")
