import argparse
import os

import yaml

from crypta.lib.python import yaml2proto


def load(path):
    with open(path) as f:
        return yaml.safe_load(f.read())


def dump(config, path="config.yaml"):
    abspath = os.path.abspath(path)

    with open(abspath, "w") as f:
        yaml.dump(config, f)

    return abspath


def parse_config(proto_cls, config_path):
    proto = proto_cls()

    with open(config_path) as f:
        yaml2proto.yaml2proto(f.read(), proto)

    return proto


def parse_config_from_args(proto_cls, description="", args=None):
    parser = argparse.ArgumentParser(description=description)
    parser.add_argument("--config", required=True)
    config_path = parser.parse_args(args).config

    return parse_config(proto_cls, config_path)
