import os

import yaml
import yatest.common

from crypta.lib.python import (
    yaml_config,
    yaml2proto,
)
import config_pb2


CONFIG = {
    "yt-proxy": "xxx",
    "yt-tmp-dir": "//tmp"
}


def test_dump():
    filename = "test_dump.yaml"
    path = yaml_config.dump(CONFIG, filename)

    assert os.path.abspath(filename) == path

    with open(path) as f:
        assert CONFIG == yaml.safe_load(f)


def test_load():
    filename = "test_load.yaml"

    with open(filename, "w") as f:
        yaml.dump(CONFIG, f)

    assert CONFIG == yaml_config.load(filename)


def test_load_dump():
    assert CONFIG == yaml_config.load(yaml_config.dump(CONFIG))
    assert os.path.exists("config.yaml")


def test_parse_config_from_args():
    ref = config_pb2.TConfig()
    ref.String = "string"
    ref.Int32 = 32

    config_path = yatest.common.test_output_path("config.yaml")
    with open(config_path, "w") as f:
        f.write(yaml2proto.proto2yaml(ref))

    args = ["--config", config_path]

    proto = yaml_config.parse_config_from_args(config_pb2.TConfig, args=args)

    assert ref == proto
