# https://wiki.yandex-team.ru/golovan/userdocs/panels/menutree/api/#replace
class NodeInfo(object):
    def __init__(self, owners, title):
        self.name = normalize_id(title)
        self.owners = owners
        self.title = title
        self.children = {}
        self.type = None

    def add(self, child):
        return self.children.setdefault(child.name, child)

    def to_dict(self):
        if self.type is None:
            raise NotImplementedError

        return {
            "name": self.name,
            "owners": self.owners,
            "title": self.title,
            "type": self.type,
            "children": sorted(
                [child.to_dict() for child in self.children.values()],
                key=lambda x: x["name"],
            )
        }


class TemplateNodeInfo(NodeInfo):
    def __init__(self, owners, title, item_id, substitutions=None):
        super(TemplateNodeInfo, self).__init__(owners, title)
        self.type = "template_panel"
        self.item_id = item_id
        self.substitutions = serialize_substitution(substitutions or {})

    def to_dict(self):
        result = super(TemplateNodeInfo, self).to_dict()
        result.update({
            "item_id": self.item_id,
            "substitutions": self.substitutions,
        })
        return result


class DummyNodeInfo(NodeInfo):
    def __init__(self, owners, title):
        super(DummyNodeInfo, self).__init__(owners, title)
        self.type = "dummy"


def normalize_id(title):
    return title.lower().replace(" ", "_")


def serialize_substitution(substitutions):
    return {k: serialize_substitution_value(v) for k, v in substitutions.iteritems()}


def serialize_substitution_value(value):
    if isinstance(value, (str, unicode)):
        return value
    elif isinstance(value, (list, tuple)):
        return ", ".join(value)
    raise Exception("Bad type of substitution variable, type '{}', value '{}'".format(type(value), value))
