from library.python import resource

from crypta.lib.python.yasm import (
    node_info,
    owners,
)


class Template(object):
    @classmethod
    def dump(cls):
        return {
            "abc": cls.abc,
            "key": cls.key,
            "owners": cls.owners,
            "content": cls.content,
        }


class DevopsTemplate(Template):
    abc = "CryptaIS"
    key = "crypta-devops"
    owners = owners.get_crypta_yt_owners()
    content = resource.find("crypta-devops.yasm")

    @classmethod
    def create_node(cls, itype, ctype, prj):
        title = "Devops " + ctype.capitalize()

        return node_info.TemplateNodeInfo(
            cls.owners,
            title,
            cls.key,
            dict(
                itype=itype,
                ctype=ctype,
                prj=prj,
            )
        )


def dump():
    return sorted([
        DevopsTemplate.dump(),
    ], key=lambda x: x["key"])


def upload(client):
    for template in dump():
        client.create_template(**template) if client.get_template(template["key"]) is None else client.update_template(**template)
