from crypta.lib.python.yasm import node_info


class MetaProjectTree(node_info.DummyNodeInfo):
    def add_panel(self, project, service, panel):
        node = self.add(ProjectTree(self.owners, project))
        node.add_panel(service, panel)


class ProjectTree(node_info.DummyNodeInfo):
    def add_panel(self, service, panel):
        node = self.add(node_info.DummyNodeInfo(self.owners, service))
        node.add(panel)


def upload_meta_tree(client, meta_tree):
    serialized_meta_tree = meta_tree.to_dict()
    client.replace_menutree("/" + serialized_meta_tree["name"], serialized_meta_tree)
