import functools
import logging
import os

from crypta.lib.python.yql.client import create_yql_client

logger = logging.getLogger(__name__)


def get_executer(yt_proxy, yt_pool, yt_tmp_dir, operation_spec=None, max_job_count=None, binary_cache_tmp_folder=None, binary_cache_ttl=None):
    yql_client_config = dict(
        yt_proxy=yt_proxy,
        token=os.environ["YQL_TOKEN"],
        operation_spec=operation_spec,
        max_job_count=max_job_count,
        binary_cache_tmp_folder=binary_cache_tmp_folder,
        binary_cache_ttl=binary_cache_ttl,
    )

    yql_client = create_yql_client(**yql_client_config)
    return functools.partial(yql_client.execute, pool=yt_pool, tmp_folder=yt_tmp_dir)


def get_executer_from_proto(yt_config, operation_spec=None, max_job_count=None, binary_cache_tmp_folder=None, binary_cache_ttl=None):
    return get_executer(
        yt_config.Proxy,
        yt_config.Pool,
        yt_config.TmpDir,
        operation_spec=operation_spec,
        max_job_count=max_job_count,
        binary_cache_tmp_folder=binary_cache_tmp_folder,
        binary_cache_ttl=binary_cache_ttl,
    )
