from google.protobuf.descriptor import FieldDescriptor
from google.protobuf.message_factory import MessageFactory

import library.python.protobuf.yql as yql_proto
import mapreduce.yt.interface.protos.extension_pb2 as yt_extension


def get_attr(yt_field, message_type, lists_optional=False, enum_mode="number"):
    return (
        "_yql_proto_field_{field}".format(field=yt_field),
        yql_proto.yql_proto_field(message_type, lists_optional, enum_mode)
    )


def get_attrs(message_type, lists_optional=False, enum_mode="number"):
    if yt_extension.EWrapperFieldFlag.SERIALIZATION_YT in message_type.DESCRIPTOR.GetOptions().Extensions[yt_extension.default_field_flags]:
        return dict()

    proto_fields = dict()
    message_factory = MessageFactory()

    for descriptor in message_type.DESCRIPTOR.fields:
        if descriptor.message_type is None:
            continue

        if descriptor.label == FieldDescriptor.LABEL_REPEATED:
            continue

        if yt_extension.EWrapperFieldFlag.SERIALIZATION_YT in descriptor.GetOptions().Extensions[yt_extension.flags]:
            continue

        yt_field = descriptor.GetOptions().Extensions[yt_extension.column_name] or descriptor.name
        field_message_type = message_factory.GetPrototype(descriptor.message_type)

        attr_key, attr_value = get_attr(yt_field, field_message_type, lists_optional, enum_mode)
        proto_fields[attr_key] = attr_value

    return proto_fields
