import six

from library.python import resource

from crypta.lib.python import templater
from crypta.lib.python.yql import executer
from crypta.lib.python.yql.client import create_yql_client


def get_single_value(yql_result_table):
    yql_result_table.fetch_full_data()
    return yql_result_table.rows[0][0]


def get_single_row(yql_result_table):
    result = {}

    for row in yql_result_table.rows:
        for name, value in zip(yql_result_table.column_names, row):
            result[name] = value

    return result


def run_query(query_template, yt_config, query_params, logger, tx=None, **kwargs):
    yql_executer = executer.get_executer_from_proto(yt_config)
    query_resource = resource.find(query_template)

    if query_resource is None:
        raise Exception("Resource {} not found".format(query_template))

    query_template = six.ensure_str(query_resource, "utf-8")
    query = templater.render_template(query_template, vars=query_params, strict=True)
    logger.info("Running YQL query:\n%s", query)
    return yql_executer(query, transaction=None if tx is None else tx.transaction_id, syntax_version=1, **kwargs)


def get_yql_client_from_nv_parameters(nv_parameters, tmp_directory='//tmp/yql'):
    return create_yql_client(
        yt_proxy=nv_parameters['mr-default-cluster'],
        token=nv_parameters['yql-token'],
        pool=nv_parameters['yt-pool'],
        tmp_folder=tmp_directory,
    )
