PRAGMA yson.DisableStrict;

$uniq_array = ($a, $b) -> {
    -- Join lists and return uniq elements
    -- DictKeys(SetUnion(ToSet($a), ToSet($b))) -- might be better for long arrays
    RETURN ListUniq(ListExtend($a, $b));
};

$sum_dict = ($dict1, $dict2) -> {
    -- Merge dicts with sum duplicated key values
    return SetUnion($dict1, $dict2, ($k, $a, $b) -> {
        return ($a ?? 0) + ($b ?? 0);
    });
};

$sum_dict_dict = ($dict1, $dict2) -> {
    -- Merge dict of dicts with sum duplicated key values
    return SetUnion($dict1, $dict2, ($k, $a, $b) -> {
        return Unwrap(CASE
            WHEN $a IS NOT NULL and $b IS NOT NULL
            THEN $sum_dict($a, $b)
            ELSE $a ?? $b
        END);
    });
};


-- UDAF like clickhouse groupUniqArrayArray
-- for single element use LISTDISTINCT or TopFreq
$aggregate_uniq_arrays = AggregateFlatten(
    AggregationFactory("AGGREGATE_LIST_DISTINCT"));

$aggregate_limited_uniq_arrays = ($limit) -> {
    RETURN AggregateFlatten(
        AggregationFactory("AGGREGATE_LIST_DISTINCT", $limit)
    );
};

-- UDAF to summ dicts
-- from single element
$sum_dict_create = ($item, $parent) -> { -- $state
    RETURN AsDict(($item, 1));
};

-- from dict
$sum_dicts_create = ($item, $parent) -> { -- $state
    RETURN $item;
};

-- from yson dict
$sum_yson_dicts_create = ($item, $parent) -> { -- $state
    RETURN Yson::ConvertToInt64Dict($item);
};

-- from single element
$sum_dict_add = ($state, $item, $parent) -> { -- $state
    RETURN $sum_dict($state, $sum_dict_create($item, $parent));
};

-- from dict
$sum_dicts_add = ($state, $item, $parent) -> { -- $state
    RETURN $sum_dict($state, $item);
};

-- from yson dict
$sum_yson_dicts_add = ($state, $item, $parent) -> { -- $state
    RETURN $sum_dict($state, $sum_yson_dicts_create($item, $parent));
};

-- from dicts
$sum_dicts_merge = ($state_l, $state_r) -> { -- $state
    RETURN $sum_dict($state_l, $state_r);
};

$get_or_default_dict = ($dict) -> {
    $dict_type = TypeOf($dict);
    RETURN $dict ?? DictCreate(DictKeyType($dict_type), DictPayloadType($dict_type));
};

$aggregate_sum_dict = AGGREGATION_FACTORY(
    "UDAF",
    $sum_dict_create,
    $sum_dict_add,
    $sum_dicts_merge
);

$aggregate_sum_dicts = AGGREGATION_FACTORY(
    "UDAF",
    $sum_dicts_create,
    $sum_dicts_add,
    $sum_dicts_merge
);

$aggregate_sum_yson_dicts = AGGREGATION_FACTORY(
    "UDAF",
    $sum_yson_dicts_create,
    $sum_yson_dicts_add,
    $sum_dicts_merge
);

-- UDAF to summ dict of dicts
$sum_dict_dict_create = ($item, $parent) -> { -- $state
    RETURN $item;
};

$sum_dict_dict_add = ($state, $item, $parent) -> { -- $state
    RETURN $sum_dict_dict($state, $item);
};

$sum_dict_dict_merge = ($state_l, $state_r) -> { -- $state
    RETURN $sum_dict_dict($state_l, $state_r);
};

$aggregate_sum_dict_dicts = AGGREGATION_FACTORY(
    "UDAF",
    $sum_dict_dict_create,
    $sum_dict_dict_add,
    $sum_dict_dict_merge
);

-- UDAF to aggregate tuple dict
$dict_agg_create = ($item, $parent) -> { -- $state
    RETURN $item;
};

$dict_agg_add = ($state, $item, $parent) -> { -- $state
    RETURN ToDict(ListExtend(DictItems($state), DictItems($item)));
};

$dict_agg_merge = ($state_l, $state_r) -> { -- $state
    RETURN ToDict(ListExtend(DictItems($state_l), DictItems($state_r)));
};

$flat_multi_dict = ($multi_dict) -> {
    RETURN ListFlatMap(
        DictItems($multi_dict),
        ($pair) -> {
            RETURN ListMap(
                ListUniq($pair.1),
                ($item) -> {
                    RETURN AsTuple($pair.0, $item);
                }
            )
        }
    );
};

$dict_agg_multi_add =  ($state, $item, $parent) -> { -- $state
    RETURN ToMultiDict(ListExtend($flat_multi_dict($state), $flat_multi_dict($item)));
};

$dict_agg_multi_merge = ($state_l, $state_r) -> { -- $state
    RETURN ToMultiDict(ListExtend($flat_multi_dict($state_l), $flat_multi_dict($state_r)));
};

$aggregate_merge_dicts = AGGREGATION_FACTORY(
    "UDAF",
    $dict_agg_create,
    $dict_agg_add,
    $dict_agg_merge
);

$aggregate_merge_multi_dicts = AGGREGATION_FACTORY(
    "UDAF",
    $dict_agg_create,
    $dict_agg_multi_add,
    $dict_agg_multi_merge
);

-- Represent YQL dict<> as YSON (TODO: remove it in future)
$dump_as_dict_int = ($dict) -> {
    $items_type = TypeOf(DictItems($dict));
    RETURN Yson::Serialize(Yson::FromInt64Dict(
        ToDict(ListMap(
            DictItems($dict) ?? ListCreate($items_type),
            ($pair) -> {
                RETURN (CAST($pair.0 AS String), CAST($pair.1 AS Int64));
            }
        ))
    ));
};

EXPORT
    $uniq_array,
    $sum_dict,
    $sum_dict_dict,
    $aggregate_uniq_arrays,
    $aggregate_limited_uniq_arrays,
    $aggregate_sum_dict,
    $aggregate_sum_dicts,
    $aggregate_sum_yson_dicts,
    $aggregate_sum_dict_dicts,
    $aggregate_merge_dicts,
    $aggregate_merge_multi_dicts,
    $flat_multi_dict,
    $dump_as_dict_int
;
