$config = AsStruct(
    -- ==== YUID-YUID PAIRS =====
    -- source types
    'passport' AS ID_SOURCE_TYPE_PASSPORT,
    'passport_dump' AS ID_SOURCE_TYPE_PASSPORT_DUMP,
    'passport_sensitive' AS ID_SOURCE_TYPE_PASSPORT_SENSITIVE,
    -- server side passport logs
    'passport_server' AS ID_SOURCE_TYPE_PASSPORT_SERVER,
    'wl_mailru' AS ID_SOURCE_TYPE_WATCH_LOG_MAILRU,
    'social' AS ID_SOURCE_TYPE_SOCIAL,
    'page_title' AS ID_SOURCE_TYPE_PAGE_TITLE,
    'webvisor' AS ID_SOURCE_TYPE_WEBVISOR,
    'sender' AS ID_SOURCE_TYPE_SENDER,
    'auto' AS ID_SOURCE_TYPE_AUTO,
    'kp' AS ID_SOURCE_TYPE_KINOPOISK,
    'yamoney' AS ID_SOURCE_TYPE_YAMONEY,
    'tickets' AS ID_SOURCE_TYPE_TICKETS,
    -- desktop yandex browser and bar plugins
    'barlog' AS ID_SOURCE_TYPE_BARLOG,
    -- export access log
    'eal' AS ID_SOURCE_TYPE_EAL,
    -- export access log :: external browsers from YaBro
    'ext_bro' AS ID_SOURCE_TYPE_EXTERNAL_BROWSERS,
    -- sbapi-mitb log
    'bm' AS ID_SOURCE_TYPE_BROWSER_MANAGER,
    -- export access log punto switcher
    'punto' AS ID_SOURCE_TYPE_PUNTO,
    -- yandex browser reports cookies of neighbour browsers
    'neighbour_cookies' AS ID_SOURCE_TYPE_NEIGHBOUR_COOKIES,
    -- only for those fingerprints ids, that do no have several sources or specific types
    'fp' AS ID_SOURCE_TYPE_FP,
    'watch_log' AS ID_SOURCE_TYPE_WATCH_LOG,
    'mm' AS ID_SOURCE_TYPE_MOBILE_METRIKA,
    'vk' AS ID_SOURCE_TYPE_VK,
    'ditmsk' AS ID_SOURCE_TYPE_DITMSK,
    'instagram_pochta' AS ID_SOURCE_TYPE_INSTAGRAM_POCHTA,
    'sovetnik' AS ID_SOURCE_TYPE_SOVETNIK,

    -- not used to match
    -- special events in watch log
    'ecommerce' AS ID_SOURCE_TYPE_ECOMMERCE_LOG,

    -- mobile source types
    'am' AS ID_SOURCE_TYPE_ACCOUNT_MANAGER,
    'oauth' AS ID_SOURCE_TYPE_PASSPORT_OAUTH,
    'track' AS ID_SOURCE_TYPE_TRACK,
    'redir' AS ID_SOURCE_TYPE_REDIR,
    'startup' AS ID_SOURCE_TYPE_STARTUP,
    'sdk' AS ID_SOURCE_TYPE_SDK,
    'mob_report' AS ID_SOURCE_TYPE_MOB_REPORT,
    'yabrowser_android' AS ID_SOURCE_TYPE_YABROWSER_ANDROID,
    'yabrowser_ios' AS ID_SOURCE_TYPE_YABROWSER_IOS,
    'fuzzy' AS ID_SOURCE_TYPE_FUZZY,
    'access_log' AS ID_SOURCE_TYPE_ACCESS_LOG,
    'appsflyer' AS ID_SOURCE_TYPE_APPSFLYER,
    'vmetro' AS ID_SOURCE_TYPE_VMETRO,
    'postclick' AS ID_SOURCE_TYPE_POSTCLICK,
    'metrica_sockets_android' AS ID_SOURCE_TYPE_METRICA_SOCKETS_ANDROID,
    'metrica_sockets_ios' AS ID_SOURCE_TYPE_METRICA_SOCKETS_IOS,
    'watch_yp_did_ios' AS ID_SOURCE_TYPE_WATCH_YP_IOS,
    'watch_yp_did_android' AS ID_SOURCE_TYPE_WATCH_YP_ANDROID,
    'access_yp_did_ios' AS ID_SOURCE_TYPE_ACCESS_YP_IOS,
    'access_yp_did_android' AS ID_SOURCE_TYPE_ACCESS_YP_ANDROID,

    -- === id types ===

    -- basic matching ids
    'devid' AS ID_TYPE_DEVID,
    'devidhash' AS ID_TYPE_DEVID_HASH,
    'uuid' AS ID_TYPE_UUID,
    'yuid' AS ID_TYPE_YUID,
    'icookie' AS ID_TYPE_ICOOKIE,
    'mac' AS ID_TYPE_MAC,

    'fuid' AS ID_TYPE_FUID,
    'puid' AS ID_TYPE_PUID,
    'vk' AS ID_TYPE_VKCOM,
    'vk_name' AS ID_TYPE_VKCOM_NAME,
    'fb' AS ID_TYPE_FACEBOOK_ID,
    'ok' AS ID_TYPE_OKRU,
    'avito' AS ID_TYPE_AVITO,

    -- client side UI for yandex software
    'ui' AS ID_TYPE_BAR_UI,
    -- server side UI for yandex software
    'r1' AS ID_TYPE_BAR_R1,
    'ip' AS ID_TYPE_IP,
    'kp_uid' AS ID_TYPE_KINOPOISK_UID,
    'instagram_id' AS ID_TYPE_INSTAGRAM_ID,
    'instagram_login' AS ID_TYPE_INSTAGRAM_LOGIN,

    'yamoney_id' AS ID_TYPE_YAMONEYID,
    'yamoney_card' AS ID_TYPE_YAMONEY_CARD_TOKEN,
    'yamoney_acc' AS ID_TYPE_YAMONEY_ACCOUNT,
    'yamoney_internal' AS ID_TYPE_YAMONEY_INTERNAL,

    'login' AS ID_TYPE_LOGIN,

    'email' AS ID_TYPE_EMAIL,
    'email_hash' AS ID_TYPE_EMAIL_HASH,
    'phone' AS ID_TYPE_PHONE,
    'phone_hash' AS ID_TYPE_PHONE_HASH,

    'socdem' AS ID_TYPE_SOCDEM,
    'date' AS ID_TYPE_DATE,
    'dit_id' AS ID_TYPE_DITID,
    'mmetric_devid' AS ID_TYPE_MMETRIC_DEVID,

    'cross' AS PAIR_TYPE_CROSS_SOURCE,

    -- webvisor date limits
    1946 AS WEBVISOR_MINYEAR,
    2000 AS WEBVISOR_MAXYEAR,

    -- not used to match
    -- region from geobase
    'region' AS ID_TYPE_REGION,
    -- any domain
    'purchase_domain' AS ID_TYPE_PURCHASE_DOMAIN,

    5 AS default_yuids_per_id_limit,
    5 AS default_ids_per_yuid_strict_limit,
    3 AS default_ids_per_yuid_soft_limit,

    2 AS TICKETS_MIN_COUNT
);


EXPORT $config;
