USE {% if is_embedded %}YtCluster{% elif is_local %}Plato{% else %}{{ yt_proxy.split('.')[0]|title }}{% endif %};  -- {{ yt_proxy }}
PRAGMA yt.DefaultCluster = '{% if is_embedded %}ytcluster{% elif is_local %}plato{% else %}{{ yt_proxy.split('.')[0]|lower }}{% endif %}';
-- ========================================================================= --
-- TITLE: {{ query_title }}
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA AnsiOrderByLimitInUnionAll;
PRAGMA DisableCoalesceJoinKeysOnQualifiedAll;
PRAGMA AnsiRankForNullableKeys;
{% if (is_embedded or is_local) -%}
PRAGMA yt.TmpFolder = '{{ tmp_dir }}';
{%- endif %}
{% if not is_test_run and enable_cloud|default(True) -%}
PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';
{%- endif %}
{% if not is_test_run and is_embedded -%}
{%- set geobase_url = 'https://proxy.sandbox.yandex-team.ru/last/GEODATA6BIN_STABLE?attrs={"released":"stable"}&salt=%s' % time.time() -%}
PRAGMA yt.GeobaseDownloadUrl = {{ "%r" % geobase_url }};
{%- endif %}
{% if pool %}PRAGMA yt.StaticPool = '{{ pool }}';{% endif %}
{% if transaction_id or tx %}PRAGMA yt.ExternalTx = '{{ transaction_id or tx }}';{% endif %}
-- ========================================================================= --
{% if udf_url_enable|default(True) and not (is_embedded or is_local) %}
DEFINE ACTION $DownloadUdf() AS{% autoescape false %}
    {%- if udf_source == 'yt' -%}
        {%- set soup_udf_url = 'yt://hahn/home/crypta/public/udfs/libcrypta_soup_udf.so' -%}
        {%- set identifier_udf_url = 'yt://hahn/home/crypta/public/udfs/libcrypta_identifier_udf.so' -%}
    {%- elif udf_source == 'sandbox' -%}
        {%- set soup_udf_url = 'https://proxy.sandbox.yandex-team.ru/last/CRYPTA_SOUP_UDF?attrs={"released":"stable"}&salt=%s' % time.time() -%}
        {%- set identifier_udf_url = 'https://proxy.sandbox.yandex-team.ru/last/CRYPTA_IDENTIFIERS_UDF?attrs={"released":"stable"}&salt=%s' % time.time() -%}
    {%- endif %}
    PRAGMA File('soup_udf.so', {{ "%r" % soup_udf_url }});
    PRAGMA File('libcrypta_identifier_udf.so', {{ "%r" % identifier_udf_url }});

    PRAGMA Udf('soup_udf.so');
    PRAGMA Udf('libcrypta_identifier_udf.so');
{% endautoescape %}END DEFINE;
DO $DownloadUdf(); COMMIT;
{% endif %}
-- ========================================================================= --

{% if soup_dates_enabled|default(False) %}
{% include '/templates/soup_lib.sql.j2' %}
{% endif %}

{% if crypta_env == "development" %}
PRAGMA yt.DefaultMaxJobFails = "1";
PRAGMA yt.QueryCacheMode = "disable";
PRAGMA yt.PythonCpu = "1.0";
PRAGMA yt.ReleaseTempData = "finish";
{% endif %}
