$_sn_id_capture = Re2::Capture('^(?P<id>\\d+)');

$_parse_sn_id_from_app_url = ($url, $api_address_field, $api_address, $app_id_field, $sn_id_field) -> {
    $decoded_url = Url::Decode($url);
    RETURN IF (Url::GetHost(Url::Decode(Url::GetCGIParam($decoded_url, $api_address_field))) == $api_address AND Url::GetCGIParam($decoded_url, $app_id_field) IS NOT NULL,
               $_sn_id_capture(Url::GetCGIParam($decoded_url, $sn_id_field)).id);
};

$_parse_vk_id_from_app_url = ($url) -> {
    RETURN $_parse_sn_id_from_app_url($url, 'api_url', 'api.vk.com', 'api_id', 'viewer_id')
};

$fp_parse_vk_id_from_url = ($url) -> {
    $decoded_url = Url::Decode($url);
    RETURN CASE Url::GetDomain($decoded_url, 2)
        WHEN 'vk.com' THEN
            $_sn_id_capture(Url::GetCGIParam($decoded_url, 'mid')).id
            ?? $_sn_id_capture(Url::GetCGIParam($decoded_url, 'viewer_id')).id
        ELSE
            $_parse_vk_id_from_app_url($decoded_url)
    END;
};

$fp_parse_ok_id_from_url = ($url) -> {
    RETURN $_parse_sn_id_from_app_url($url, 'api_server', 'api.ok.ru', 'application_key', 'logged_user_id')
};

$_parse_sn_id_from_param = ($http_param, $handler) -> {
    $url_fields = AsList('referer', 'url', 'previous-url');
    $oldurl_match = Re2::Match('^oldurl\\d+');
    RETURN IF($oldurl_match($http_param.0) OR ListHas($url_fields, $http_param.0), $handler($http_param.1))
};

$_parse_vk_id_from_param = ($param) -> {
    RETURN $_parse_sn_id_from_param($param, $fp_parse_vk_id_from_url)
};

$_parse_ok_id_from_param = ($param) -> {
    RETURN $_parse_sn_id_from_param($param, $fp_parse_ok_id_from_url)
};

$_get_http_params_list = ($query) -> {
    $unwrapped_query = $query ?? '';
    $params = IF(String::StartsWith($unwrapped_query, '?'), SUBSTRING($unwrapped_query, 1), $unwrapped_query);
    RETURN DictItems(Dsv::Parse($params, '&'))
};

$_fp_parse_sn_id_from_http_params = ($http_params, $handler) -> {
    RETURN ListFlatMap(ListNotNull($_get_http_params_list($http_params)), $handler)[0];
};

$fp_parse_vk_id_from_http_params = ($http_params) -> {
    RETURN $_fp_parse_sn_id_from_http_params($http_params, $_parse_vk_id_from_param)
};

$fp_parse_ok_id_from_http_params = ($http_params) -> {
    RETURN $_fp_parse_sn_id_from_http_params($http_params, $_parse_ok_id_from_param)
};

EXPORT
    $fp_parse_vk_id_from_url, $fp_parse_ok_id_from_url, $fp_parse_vk_id_from_http_params, $fp_parse_ok_id_from_http_params;
