DEFINE SUBQUERY $soup_dates($soup_root, $id_type) AS
    SELECT
        id_type, id,
        MIN(date_begin) AS date_begin,
        MAX(date_end) AS date_end,
    FROM (
        SELECT
            $id_type AS id_type,
            CASE
                WHEN id1Type == $id_type THEN id1
                WHEN id2Type == $id_type THEN id2
                ELSE NULL
            END AS id,
            ListMin(dates) AS date_begin,
            ListMax(dates) AS date_end
        FROM LIKE($soup_root, '%' || $id_type || '%')
        WITH SCHEMA Struct<
            `dates`: List<String>?,
            id1: String,
            id1Type: String,
            id2: String,
            id2Type: String,
        >
    ) WHERE id IS NOT NULL
    GROUP BY id_type, id;
END DEFINE;
