{#
    NODE: use as INCLUDE in jinja, not as YQL Lib
    {% include '/templates/stream.sql.j2' %}
#}
-- ========================================================================= --

DEFINE SUBQUERY $get_all_tables($directory) AS
    -- Select all tables from given folder
    SELECT '//' || `Path` AS `path`
    FROM FOLDER($directory, 'row_count')
    WHERE Type = 'table' AND
        Yson::LookupInt64(Attributes, 'row_count') > 0
    ;
END DEFINE;

DEFINE SUBQUERY $get_unprocessed_tables($directory, $processed_tables) AS
    -- Select only unprocessed tables
    SELECT tables ?? ListCreate(String) AS tables FROM (
        SELECT AGGREGATE_LIST_DISTINCT(`path`) AS tables FROM (
            SELECT tbls.`path` AS `path` FROM $get_all_tables($directory) AS tbls
            LEFT ONLY JOIN $processed_tables AS processed
            USING (`path`)
        )
    );
END DEFINE;

DEFINE SUBQUERY $get_all_tables_list($directory) AS
    -- Select list of tables
    SELECT tables ?? ListCreate(String) AS tables FROM (
        SELECT AGGREGATE_LIST_DISTINCT(`path`) AS tables FROM $get_all_tables($directory)
    );
END DEFINE;

DEFINE SUBQUERY $get_all_tables_by_date($directory, $date) AS
    -- Select tables with filter
    SELECT `path`
        FROM $get_all_tables($directory)
        WHERE `path` LIKE ("%" || $date || "%")
    ;
END DEFINE;

-- ========================================================================= --
DEFINE ACTION $parse_stream($tables, $query, $fresh_tables_output, $output_name) AS
    $result_table = $fresh_tables_output || '/' || $output_name;
    -- ===================================================================== --
    SELECT $result_table INTO RESULT `result table`;

    SELECT `path`
    FROM (SELECT Unwrap($tables) AS unprocessed)
    FLATTEN LIST BY unprocessed AS `path`
    INTO RESULT `processed tables`;
    -- ===================================================================== --
    INSERT INTO $result_table WITH TRUNCATE
    SELECT dt, is_tv, yuid, ip, COUNT(1) AS hits
    FROM $query($tables)
    WHERE yuid != 0
    GROUP BY dt, yuid, is_tv, ip
    ORDER BY dt, is_tv, yuid;

    COMMIT;

    INSERT INTO `{{ processed_tables }}_dates`
    SELECT DISTINCT dt FROM $result_table;

END DEFINE;

DEFINE SUBQUERY $skip_each($tables_list, $denominator) AS
    SELECT AGGREGATE_LIST_DISTINCT(`path`) AS tables
    FROM (
        SELECT `path`, ROW_NUMBER() OVER w AS row
        FROM $tables_list()
        WINDOW w AS ()
    ) WHERE (row % $denominator == 0);
END DEFINE;
