$lower_strip = ($str) -> {
    RETURN String::Strip(String::ToLower($str) ?? '');
};

$non_word_splitter = Re2::FindAndConsume(@@([a-z\d]+)@@);

$final_chance = ($vendor) -> {
    $clean = String::JoinFromList($non_word_splitter($vendor), '_');
    RETURN IF(LEN($clean) > 0, $clean, 'un');
};

$get_vendor = ($vendor) -> {
    RETURN CASE
        -- startswih
        WHEN String::StartsWith($vendor, 'acer') THEN 'acer'
        WHEN String::StartsWith($vendor, 'asus') THEN 'asus'
        WHEN String::StartsWith($vendor, 'htc') THEN 'htc'
        WHEN String::StartsWith($vendor, '4good') THEN '4good'
        WHEN String::StartsWith($vendor, 'azumi') THEN 'azumi'
        WHEN String::StartsWith($vendor, 'casper') THEN 'casper'
        WHEN String::StartsWith($vendor, 'dell') THEN 'dell'
        WHEN String::StartsWith($vendor, 'dexp') THEN 'dexp'
        WHEN String::StartsWith($vendor, 'discovery') THEN 'discovery'
        WHEN String::StartsWith($vendor, 'explay') THEN 'explay'
        WHEN String::StartsWith($vendor, 'fly') THEN 'fly'
        WHEN String::StartsWith($vendor, 'haier') THEN 'haier'
        WHEN String::StartsWith($vendor, 'highscreen') THEN 'highscreen'
        WHEN String::StartsWith($vendor, 'hp') THEN 'hp'
        WHEN String::StartsWith($vendor, 'hw') THEN 'hw'
        WHEN String::StartsWith($vendor, 'infinix') THEN 'infinix'
        WHEN String::StartsWith($vendor, 'irbis') THEN 'irbis'
        WHEN String::StartsWith($vendor, 'lg') THEN 'lg'
        WHEN String::StartsWith($vendor, 'mtc') THEN 'mtc'
        WHEN String::StartsWith($vendor, 'myphone') THEN 'myphone'
        WHEN String::StartsWith($vendor, 'onda') THEN 'onda'
        WHEN String::StartsWith($vendor, 'oneplus') THEN 'oneplus'
        WHEN String::StartsWith($vendor, 'oppo') THEN 'oppo'
        WHEN String::StartsWith($vendor, 'orange') THEN 'orange'
        WHEN String::StartsWith($vendor, 'pantech') THEN 'pantech'
        WHEN String::StartsWith($vendor, 'qmobile') THEN 'qmobile'
        WHEN String::StartsWith($vendor, 'senseit') THEN 'senseit'
        WHEN String::StartsWith($vendor, 'sharp') THEN 'sharp'
        WHEN String::StartsWith($vendor, 'spreadtrum') THEN 'spreadtrum'
        WHEN String::StartsWith($vendor, 'symphony') THEN 'symphony'
        WHEN String::StartsWith($vendor, 'tcl') THEN 'tcl'
        WHEN String::StartsWith($vendor, 'tecno') THEN 'tecno'
        WHEN String::StartsWith($vendor, 'tele2') THEN 'tele2'
        WHEN String::StartsWith($vendor, 'texet') THEN 'texet'
        WHEN String::StartsWith($vendor, 'unimax') THEN 'unimax'
        WHEN String::StartsWith($vendor, 'vertu') THEN 'vertu'
        WHEN String::StartsWith($vendor, 'vivo') THEN 'vivo'
        WHEN String::StartsWith($vendor, 'wexler') THEN 'wexler'
        WHEN String::StartsWith($vendor, 'xiaomi') THEN 'xiaomi'
        -- contains
        WHEN String::Contains($vendor, 'apple') THEN 'apple'
        WHEN String::Contains($vendor, 'samsung') THEN 'samsung'
        WHEN String::Contains($vendor, 'alcatel') THEN 'alcatel'
        WHEN String::Contains($vendor, 'andromax') THEN 'andromax'
        WHEN String::Contains($vendor, 'archos') THEN 'archos'
        WHEN String::Contains($vendor, 'beeline') THEN 'beeline'
        WHEN String::Contains($vendor, 'coolpad') THEN 'coolpad'
        WHEN String::Contains($vendor, 'doogee') THEN 'doogee'
        WHEN String::Contains($vendor, 'garmin') THEN 'garmin'
        WHEN String::Contains($vendor, 'google') THEN 'google'
        WHEN String::Contains($vendor, 'huawei') THEN 'huawei'
        WHEN String::Contains($vendor, 'hyundai') THEN 'hyundai'
        WHEN String::Contains($vendor, 'jiayu') THEN 'jiayu'
        WHEN String::Contains($vendor, 'keneksi') THEN 'keneksi'
        WHEN String::Contains($vendor, 'lenovo') THEN 'lenovo'
        WHEN String::Contains($vendor, 'mediatek') THEN 'mediatek'
        WHEN String::Contains($vendor, 'megafon') THEN 'megafon'
        WHEN String::Contains($vendor, 'meizu') THEN 'meizu'
        WHEN String::Contains($vendor, 'micromax') THEN 'micromax'
        WHEN String::Contains($vendor, 'microsoft') THEN 'microsoft'
        WHEN String::Contains($vendor, 'motorola') THEN 'motorola'
        WHEN String::Contains($vendor, 'nokia') THEN 'nokia'
        WHEN String::Contains($vendor, 'oysters') THEN 'oysters'
        WHEN String::Contains($vendor, 'panasonic') THEN 'panasonic'
        WHEN String::Contains($vendor, 'philips') THEN 'philips'
        WHEN String::Contains($vendor, 'prestigio') THEN 'prestigio'
        WHEN String::Contains($vendor, 'sony') THEN 'sony'
        WHEN String::Contains($vendor, 'turkcell') THEN 'turkcell'
        WHEN String::Contains($vendor, 'vodafone') THEN 'vodafone'
        -- other cases
        WHEN $vendor == 'uzte'
            OR String::StartsWith($vendor, 'zte') THEN 'zte'
        WHEN $vendor IN (
            'general mobile',
            'general_mobile',
            'general+mobile',
            'generalmobile') THEN 'general_mobile'
        WHEN $vendor == 'supra'
            OR String::StartsWith($vendor, 'supra ') THEN 'supra'
        WHEN $vendor == 'dns'
            OR String::StartsWith($vendor, 'dns ')
            OR String::StartsWith($vendor, 'dns_') THEN 'dns'
        WHEN $vendor == 'nomi'
            OR String::StartsWith($vendor, 'nomi ')
            OR String::StartsWith($vendor, 'nomi_') THEN 'nomi'
        WHEN $vendor == 'bq'
            OR String::StartsWith($vendor, 'bq ')
            OR String::StartsWith($vendor, 'bqs-')
            OR String::StartsWith($vendor, 'bq-') THEN 'bq'
        WHEN String::StartsWith($vendor, 'arkelectronic')
            OR String::StartsWith($vendor, 'ark-electronic')
            OR String::StartsWith($vendor, 'ark+electronic')
            OR String::StartsWith($vendor, 'ark benefit') THEN 'ark'
        ELSE $final_chance($vendor)
    END;
};


$_ver_3 = Re2::Capture(@@(?P<version>\d+(\.\d+){0,2})@@);
$get_dot_version = ($os_version) -> {
    RETURN $_ver_3($os_version).version ?? '';
};


$_ver = Re2::Capture(@@(?P<version>^\d+)@@);
$get_first_digit_version = ($os_version) -> {
    RETURN $_ver($os_version).version ?? '';
};


$get_mobile_platform = ($app_platform, $os_version, $vendor) -> {
    $app_platform = CASE
        WHEN String::Contains($app_platform, 'ios')
            OR String::Contains($app_platform, 'ipad')
            OR String::Contains($app_platform, 'iphone') THEN 'ios'
        WHEN String::Contains($app_platform, 'android')
            OR String::Contains($app_platform, 'apad') THEN 'android'
        WHEN String::Contains($app_platform, 'windowsmobile')
            OR String::Contains($app_platform, 'windowsphone')
            OR String::Contains($app_platform, 'windows phone')
            OR String::Contains($app_platform, 'wp')
            OR String::Contains($app_platform, 'windows')
            OR String::Contains($app_platform, 'winrt') THEN 'windows'
        WHEN String::Contains($app_platform, 'bada')
            OR String::Contains($app_platform, 'tizen') THEN $app_platform
        ELSE ''
    END;

    $os_version = CASE
        WHEN $app_platform == 'windows' THEN $get_first_digit_version($os_version)
        ELSE $get_dot_version($os_version)
    END;

    RETURN CASE
        WHEN $app_platform == '' THEN ('', '')
        ELSE ($get_vendor($vendor) || '|' || $app_platform, $os_version)
    END;
};


$encode_startup = ($app_platform, $os_version, $vendor, $device_type, $model) -> {
    -- clean variables
    $app_platform = $lower_strip($app_platform);
    $os_version = $lower_strip($os_version);
    $vendor = $lower_strip($vendor);
    $device_type = $lower_strip($device_type);
    $model = $lower_strip($model);
    -- clean venodr
    $vendor = CASE
        -- For some reason lg nexus in uatraites has google as vendor
        WHEN String::Contains($model, 'nexus') AND $vendor == 'lg' THEN 'google'
        ELSE $vendor
    END;
    -- make result
    $tuple = $get_mobile_platform($app_platform, $os_version, $vendor);
    $platform = $tuple.0;
    $ver = $tuple.1;
    RETURN String::JoinFromList(AsList('m', $device_type, $platform, $ver), '|');
};

$get_platform = ($profile_info) -> {
    $vendor = $lower_strip($profile_info.DeviceVendor);
    $app_platform = $lower_strip($profile_info.OSFamily);
    $os_version = $lower_strip($profile_info.OSVersion);

    $platform_type = CASE
        WHEN $profile_info.isTV THEN 'd|tv'
        WHEN $profile_info.isTablet THEN 'm|tablet'
        WHEN $profile_info.isMobile THEN 'm|phone'
        ELSE 'd|desk'
    END;

    $tuple = CASE
        WHEN String::StartsWith($platform_type, 'd') THEN ($app_platform, $os_version)
        ELSE $get_mobile_platform($app_platform, $os_version, $vendor)
    END;

    RETURN AsList($platform_type, $tuple.0, $tuple.1);
};

$ua_profile_str = ($ua_parsed) -> {
    RETURN String::JoinFromList($get_platform($ua_parsed), '|');
};

$ua_is_bad = ($user_agent, $ua_parsed) -> {
    $metrica_sdk = 'com.yandex.mobile.metrica.ads.sdk';
    RETURN String::StartsWith($user_agent, $metrica_sdk)
        OR Not $ua_parsed.isBrowser
        OR $ua_parsed.isEmulator
        OR $ua_parsed.isRobot
    ;
};

EXPORT $encode_startup, $ua_profile_str, $ua_is_bad;
