from jinja2 import Environment

from crypta.lib.python.yql_runner.base_parser import BaseParser


class YqlRunner(BaseParser):

    """ Run custom YQL query """

    def __init__(self, query, is_embedded=True, **kwargs):
        super(YqlRunner, self).__init__(date=None, is_embedded=is_embedded, **kwargs)
        self.query = query

    def render_query(self, **kwargs):
        if self._query is None:
            formatted_header = super(YqlRunner, self).render_query(**kwargs)
            rendered_body = Environment().from_string(self.query).render(**self.get_context_data(**kwargs))

            self._query = "\n".join((formatted_header, rendered_body))
        return self._query
