PY23_LIBRARY()

OWNER(
    g:crypta
    g:crypta-lib
    g:crypta-idfy
    mskorokhod
)

PEERDIR(
    contrib/python/cached-property
    contrib/python/ipython
    contrib/python/Jinja2

    crypta/lib/python/bt/tasks
    crypta/lib/python/getoptpb
    crypta/lib/python/jinja_resource
    crypta/lib/python/yql/client

    library/python/resource

    yql/library/embedded/python
    yql/library/python
)

PY_SRCS(
    __init__.py
    base_parser.py
    runner.py
    task.py
    util_random.pyx
)

RESOURCE(
    query/aggregation_lib.sql   /lib/aggregation_lib.sql
    query/metrica_lib.sql       /lib/metrica_lib.sql
    query/ut_utils_lib.sql      /lib/ut_utils_lib.sql
    query/config.sql            /lib/config.sql
    query/sn_id_parse_lib.sql   /lib/sn_id_parse_lib.sql

    query/header.sql            header.sql.j2

    query/soup_lib.sql          /templates/soup_lib.sql.j2
    query/stream.sql            /templates/stream.sql.j2
)

END()

RECURSE_ROOT_RELATIVE(
    # yql common udfs
    ydb/library/yql/udfs/common/datetime
    ydb/library/yql/udfs/common/datetime2
    ydb/library/yql/udfs/common/digest
    yql/udfs/common/file
    yql/udfs/common/geo
    yql/udfs/common/geohash
    ydb/library/yql/udfs/common/histogram
    ydb/library/yql/udfs/common/hyperloglog
    ydb/library/yql/udfs/common/hyperscan
    yql/udfs/common/ip
    ydb/library/yql/udfs/common/math
    ydb/library/yql/udfs/common/pire
    yql/udfs/common/protobuf
    yql/udfs/common/python/python_arc_small
    ydb/library/yql/udfs/common/re2
    ydb/library/yql/udfs/common/set
    ydb/library/yql/udfs/common/stat
    ydb/library/yql/udfs/common/string
    ydb/library/yql/udfs/common/topfreq
    yql/udfs/common/unicode
    yql/udfs/common/url
    yql/udfs/common/user_agent
    ydb/library/yql/udfs/common/yson2
    ydb/library/yql/udfs/common/json2
    # non common udfs
    ydb/library/yql/udfs/logs/dsv
    yql/udfs/metrika
    # crypta udfs
    yql/udfs/crypta/extfp_exp_udf
    yql/udfs/crypta/identifiers
    yql/udfs/crypta/ipreq
    yql/udfs/crypta/rtgeo
    yql/udfs/crypta/socket_decryptor
    yql/udfs/crypta/soup
    # mrjob binaries
    yql/tools/mrjob
    yql/tools/udf_resolver
)

RECURSE_FOR_TESTS(
    tests
)
