import logging

import yt.wrapper as yt

from crypta.lib.python.yt import yt_helpers


logger = logging.getLogger(__name__)


def dump_table(client, src_path, dst_path, yt_pool, timestamp=None):
    logger.info("Dumping replica %s to %s", src_path, dst_path)

    if not client.exists(dst_path):
        client.create_table(dst_path)

    if yt_helpers.has_optimize_for(client, src_path):
        yt_helpers.set_attribute(dst_path, "optimize_for", yt_helpers.get_optimize_for(client, src_path), client)

    client.alter_table(dst_path, schema=yt_helpers.get_attribute(src_path, "schema", client))

    if timestamp is not None:
        src_path = yt.ypath.YPath(src_path, attributes={"timestamp": timestamp})

    client.run_merge(src_path, dst_path, mode="ordered", sync=True, spec={"pool": yt_pool})
