import copy
import logging

import yt.wrapper as yt


logger = logging.getLogger(__name__)


def _get_keys(schema):
    return [x["name"] for x in schema if "sort_order" in x]


def _get_unsorted_schema(schema):
    unsorted_schema = copy.deepcopy(schema)

    for field in unsorted_schema:
        if "sort_order" in field:
            del field["sort_order"]
    unsorted_schema.attributes["unique_keys"] = False
    return unsorted_schema


def convert_to_kv(yt_client, src_path, dst_path, schema, additional_attributes=None):
    logger.info("[%s] Converting %s to %s with schema %s", yt_client.config["proxy"]["url"], src_path, dst_path, schema)
    yt_client.run_merge(
        src_path,
        yt.YPath(dst_path, attributes={"schema": _get_unsorted_schema(schema)}),
        spec={'schema_inference_mode': 'from_output'}
    )

    attributes = additional_attributes or {}
    attributes["schema"] = schema

    yt_client.run_sort(
        dst_path,
        yt.YPath(dst_path, attributes=attributes),
        sort_by=_get_keys(schema)
    )
