import six

from crypta.lib.python.yt import yt_helpers


class KvClient(object):
    def __init__(self, yt_client, path):
        self.yt_client = yt_client
        assert self.yt_client.config["backend"] == "rpc"
        self.path = path

    def transaction(self):
        return self.yt_client.Transaction(type="tablet")

    def lookup_many(self, keys):
        return _result_to_dict(
            self.yt_client.lookup_rows(self.path, ({"key": key} for key in keys))
        )

    def write_many(self, records):
        self.yt_client.insert_rows(self.path, [{"key": k, "value": v} for k, v in six.iteritems(records)])

    def delete_many(self, keys):
        self.yt_client.delete_rows(self.path, [{"key": k} for k in keys])

    def lookup(self, key):
        return self.lookup_many([key]).get(key)

    def write(self, key, value):
        self.write_many({key: value})

    def delete(self, key):
        self.delete_many([key])

    def select(self, query):
        return _result_to_dict(
            self.yt_client.select_rows("* FROM [{path}] {query}".format(path=self.path, query=query))
        )


def make_kv_client(proxy, path, token=None):
    return KvClient(
        yt_helpers.get_yt_client(proxy, yt_token=token, with_rpc=True),
        path,
    )


def _result_to_dict(result):
    return {x["key"]: x["value"] for x in result}
