from util.generic.string cimport TString

from yt import yson


cdef extern from "yt/yt/client/table_client/schema.h" namespace "NYT::NTableClient":
    cdef cppclass TTableSchema:
        pass

cdef extern from "crypta/lib/native/yt/dyntables/kv_schema/kv_schema.h" namespace 'NCrypta::NYtDynTables':
    cdef TTableSchema MakeKvSchema()
    cdef TString SchemaToYsonString(const TTableSchema& schema)

def get():
    cdef TTableSchema schema = MakeKvSchema()
    return yson.loads(SchemaToYsonString(schema))


MAX_UINT64 = 2**64 - 1


# https://wiki.yandex-team.ru/yt/userdoc/api/#reshardtable
def create_pivot_keys(tablets_count):
    step = MAX_UINT64 / tablets_count
    return [[]] + [[yson.YsonUint64(step * i)] for i in xrange(1, tablets_count)]


