from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.dyntables.kv_master import KvMaster
from crypta.lib.python.yt.dyntables.kv_replica import KvReplica


def remove_dyntable(client, path):
    if client.exists(path):
        client.unmount_table(path, sync=True)
        client.remove(path)


def kv_setup(master_cluster_client, replica_clusters, master_path, replica_path, schema, pivot_keys, bundle="default", sync=False,
             enable_tablet_balancer=True, sync_replica_count=None, enable_replicated_table_tracker=False):
    remove_dyntable(master_cluster_client, master_path)

    kv_master = KvMaster.create(
        master_cluster_client,
        master_path,
        schema,
        pivot_keys,
        bundle=bundle,
        enable_tablet_balancer=enable_tablet_balancer,
        sync_replica_count=sync_replica_count,
        enable_replicated_table_tracker=enable_replicated_table_tracker,
    )

    kv_replicas = []
    for replica_cluster_name, replica_client in replica_clusters:
        remove_dyntable(replica_client, replica_path)
        kv_replicas.append(KvReplica.create(kv_master, replica_cluster_name, replica_path, replica_client, sync=sync, bundle=bundle))

    yt_helpers.wait_for_replicas_enabled(master_cluster_client, master_path)

    return kv_master, kv_replicas
