import pytest

from crypta.lib.python.yt.dyntables import(
    kv_schema,
    kv_setup,
)
from crypta.lib.python.yt.local_tests import local_clusters


@pytest.fixture(scope="session")
def replica_names():
    yield ["replica1", "replica2"]


@pytest.fixture(scope="session")
def yt_clusters(replica_names):
    clusters = local_clusters.start_local_clusters(replica_names)

    try:
        yield clusters
    finally:
        for cluster in clusters.values():
            cluster.stop_local_yt()


@pytest.fixture
def yt_kv(yt_clusters):
    class YtReplicatedDyntables(object):
        def __init__(self, yt_clusters):
            schema = kv_schema.get()
            pivot_keys = kv_schema.create_pivot_keys(1)

            self.clusters = yt_clusters
            self.replica_path = "//replica"
            self.master, self.replicas = kv_setup.kv_setup(
                yt_clusters.values()[0].get_yt_client(),
                [(name, cluster.get_yt_client()) for name, cluster in yt_clusters.iteritems()],
                "//master",
                self.replica_path,
                schema,
                pivot_keys,
                sync=True,
            )

    return YtReplicatedDyntables(yt_clusters)
