import os

import tvmauth

from crypta.lib.python.yt.http_mapper import mapper
from crypta.lib.python.tvm import helpers as tvm


class TvmHttpRequestsMapper(mapper.HttpRequestsMapper):
    TVM_SECRET_ENV_VAR = "TVM_SECRET"
    YT_SECURE_VAULT_TVM_SECRET_ENV_VAR = "YT_SECURE_VAULT_{}".format(TVM_SECRET_ENV_VAR)

    def __init__(self, tvm_src_id, tvm_dst_id, *args, **kwargs):
        self.tvm_src_id = tvm_src_id
        self.tvm_dst_id = tvm_dst_id
        self.tvm_test_port = tvm.get_tvm_test_port()
        self.tvm_client = None

        super(TvmHttpRequestsMapper, self).__init__(*args, **kwargs)

    def start(self):
        super(TvmHttpRequestsMapper, self).start()
        self.init_tvm_manager()

    def init_tvm_manager(self):
        settings = tvmauth.TvmApiClientSettings(
            self_tvm_id=self.tvm_src_id,
            self_secret=os.environ[self.YT_SECURE_VAULT_TVM_SECRET_ENV_VAR],
            dsts=[self.tvm_dst_id],
            localhost_port=self.tvm_test_port,
        )

        self.tvm_client = tvmauth.TvmClient(settings)

    def get_headers(self):
        return tvm.get_tvm_headers(self.tvm_client.get_service_ticket_for(tvm_id=self.tvm_dst_id))
