from __future__ import absolute_import
import collections
import logging
import time

import six
from yt.wrapper import ypath

from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.solomon import reporter


logger = logging.getLogger(__name__)

YtMetricConfig = collections.namedtuple("YtMetricConfig", ["proxy", "root", "path", "env", "project", "is_recursive"])

PUSH_INTERVAL_SEC = 1


def _inspect_nodes_recursive(yt_client, solomon_client, proxy, path, get_recursive_metrics):
    if not callable(get_recursive_metrics):
        return
    for table_path, metrics in get_recursive_metrics(yt_client, path):
        for metric, value in six.iteritems(metrics):
            solomon_client.set_value(table_path, value, labels={"metric": metric, "yt_proxy": proxy})


def process_yt_metrics(config, get_metrics, solomon_client_kwargs, get_recursive_metrics=None):
    reporters = {}

    def get_reporter(**kwargs):
        key = tuple(kwargs.items())
        if key not in reporters:
            reporters[key] = reporter.create_throttled_solomon_reporter(
                push_interval=PUSH_INTERVAL_SEC,
                **kwargs
            )

        return reporters[key]

    for metric_config in config:
        try:
            solomon_client = get_reporter(
                cluster=metric_config.env,
                project=metric_config.project,
                **solomon_client_kwargs
            )

            yt_client = yt_helpers.get_yt_client(metric_config.proxy)
            path = ypath.ypath_join(metric_config.root, metric_config.path)
            if not yt_client.exists(path):
                logger.warn("%s doesn't exist", path)
                continue

            metrics = get_metrics(yt_client, path)
            for metric, value in six.iteritems(metrics):
                solomon_client.set_value(metric_config.path, value, labels={"metric": metric, "yt_proxy": metric_config.proxy})

            if metric_config.is_recursive:
                _inspect_nodes_recursive(yt_client, solomon_client, metric_config.proxy, path, get_recursive_metrics)

        except Exception:
            logger.exception("Failed to process %s", metric_config)

    # Ensure all throttled solomon reporters push their metrics
    time.sleep(PUSH_INTERVAL_SEC * 3)
