class ProcessedTracker(object):
    item_field_name = "item"

    def __init__(self, yt_client, track_table):
        self.yt_client = yt_client
        self.track_table = track_table

    def _get_unprocessed(self, current_items):
        processed_items = self._get_processed()
        return sorted(current_items.difference(processed_items), reverse=True)

    def _get_processed(self):
        return set([row[self.item_field_name] for row in self.yt_client.read_table(self.track_table)]) if self._is_track_table_exists() else set()

    def _add_processed(self, current_items, processed_item):
        processed_items = self._get_processed()
        processed_items.add(processed_item)
        processed_items = processed_items.intersection(current_items)
        processed_items = sorted(list(processed_items))[::-1]

        if not self._is_track_table_exists():
            self.yt_client.create("table", self.track_table, recursive=True)

        self.yt_client.write_table(self.track_table, [{self.item_field_name: item} for item in processed_items])

    def _is_track_table_exists(self):
        return self.yt_client.exists(self.track_table)

    def for_each_unprocessed(self, current_items, f):
        current_items = set(current_items)

        while True:
            with self.yt_client.Transaction() as tx:
                unprocessed_items = self._get_unprocessed(current_items)

                if not unprocessed_items:
                    return

                unprocessed_item = unprocessed_items[0]
                f(tx, unprocessed_item)

                self._add_processed(current_items, unprocessed_item)
