import mapreduce.yt.interface.protos.extension_pb2 as yt_extension
import yt.wrapper as yt

from crypta.lib.python.yt import schema_utils


# TODO Make proper C++ binding to account for all YT extensions
def write_proto_table(yt_client, protos, path):
    def encode(proto):
        row = {}

        for descriptor in proto.DESCRIPTOR.fields:
            value = getattr(proto, descriptor.name)
            yt_field = descriptor.GetOptions().Extensions[yt_extension.column_name] or descriptor.name

            row[yt_field] = value.SerializeToString() if descriptor.type == descriptor.TYPE_MESSAGE else value

        return row

    encoded = [encode(proto) for proto in protos]
    path = yt.TablePath(path, schema=schema_utils.get_schema_from_proto(type(protos[0])))
    yt_client.write_table(path, encoded)
