from cython.operator cimport dereference
from library.python.protobuf.dynamic_prototype.dynamic_prototype cimport (
    get_dynamic_prototype,
    TDynamicPrototype,
)
import six
from yt import yson


cdef TOneOrMany[TString] get_key_columns(columns):
    cdef TVector[TString] result
    result.reserve(len(columns))
    for column in columns:
        result.push_back(<TString>six.ensure_binary(column))
    return TOneOrMany[TString](result)


def get_schema_from_proto(message_type, key_columns=[]):
    cdef TIntrusivePtr[TDynamicPrototype] prototype = get_dynamic_prototype(message_type)

    cdef TTableSchema schema = CreateTableSchema(dereference(dereference(prototype.Get()).GetDescriptor()), get_key_columns(key_columns))
    return yson.loads(NodeToCanonicalYsonString(schema.ToNode()))
