import datetime
import pytz

from crypta.lib.python import time_utils


YT_DATETIME_FORMAT = "%Y-%m-%dT%H:%M:%S.%fZ"


def yt_date_to_datetime(time_str):
    naive_datetime = datetime.datetime.strptime(time_str, YT_DATETIME_FORMAT)
    return pytz.utc.localize(naive_datetime).astimezone(time_utils.MOSCOW_TZ)


def unixtime_to_yt_timestamp(unixtime):
    return datetime.datetime.strftime(datetime.datetime.utcfromtimestamp(unixtime), YT_DATETIME_FORMAT)


def get_current_yt_timestamp():
    return unixtime_to_yt_timestamp(time_utils.get_current_time())
