import logging
import os

import yt.transfer_manager.client as tm

from crypta.lib.python.yt import yt_helpers

logger = logging.getLogger(__name__)


def get_client(yt_token):
    return tm.TransferManager(
        token=yt_token,
        url=os.environ.get(tm.YT_TRANSFER_MANAGER_URL_ENV, None),
    )


def _run_transfer(src_cluster, src_path, dst_cluster, dst_path, tm_client):
    args = {
        "source_cluster": src_cluster,
        "source_table": src_path,
        "destination_cluster": dst_cluster,
        "destination_table": dst_path,
    }

    logger.info("Adding transfer manager task: %s", args)
    tm_client.add_task(params={"copy_spec": {"network_name": "default"}}, sync=True, **args)


def move_or_transfer_table(src_client, src_path, dst_client, dst_path, force, tm_client):
    src_cluster = yt_helpers.get_cluster_name(src_client)
    dst_cluster = yt_helpers.get_cluster_name(dst_client)

    logger.info("Copying %s at %s to %s at %s", src_path, src_cluster, dst_path, dst_cluster)
    if dst_client.exists(dst_path):
        if not force:
            logger.error("Table %s at %s exists, use force to override", dst_path, dst_cluster)
            raise Exception("Table exists")
        logger.info("Removing dst table")
        dst_client.remove(dst_path, force=True)

    logger.debug("Performing transfer")
    if src_cluster == dst_cluster:
        logger.info("Same cluster, running yt.move")
        src_client.move(src_path, dst_path, force=force)
    else:
        logger.info("Running transfer manager")
        _run_transfer(src_cluster, src_path, dst_cluster, dst_path, tm_client)
